/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import com.google.common.collect.ImmutableList;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.inventory.container.PlowContainer;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import de.mennomax.astikorcarts.util.ProxyItemUseContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public final class PlowEntity
extends AbstractDrawnInventoryEntity {
    private static final int SLOT_COUNT = 3;
    private static final double BLADEOFFSET = 1.7;
    private static final EntityDataAccessor<Boolean> PLOWING = SynchedEntityData.m_135353_(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final ImmutableList<EntityDataAccessor<ItemStack>> TOOLS = ImmutableList.of((Object)SynchedEntityData.m_135353_(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_));

    public PlowEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.spacing = 1.3;
    }

    @Override
    protected AstikorCartsConfig.CartConfig getConfig() {
        return AstikorCartsConfig.get().plow;
    }

    @Override
    protected ItemStackHandler initInventory() {
        return new CartItemStackHandler<PlowEntity>(3, this){

            protected void onLoad() {
                for (int i = 0; i < TOOLS.size(); ++i) {
                    ((PlowEntity)this.cart).m_20088_().m_135381_((EntityDataAccessor)TOOLS.get(i), (Object)this.getStackInSlot(i));
                }
            }

            protected void onContentsChanged(int slot) {
                ((PlowEntity)this.cart).updateSlot(slot);
            }
        };
    }

    public boolean getPlowing() {
        return (Boolean)this.f_19804_.m_135370_(PLOWING);
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            Player player = null;
            Entity entity = this.getPulling();
            if (entity instanceof Player) {
                Player pl;
                player = pl = (Player)entity;
            } else {
                entity = this.getPulling().m_6688_();
                if (entity instanceof Player) {
                    Player pl;
                    player = pl = (Player)entity;
                }
            }
            if (((Boolean)this.f_19804_.m_135370_(PLOWING)).booleanValue() && player != null && (this.f_19854_ != this.m_20185_() || this.f_19856_ != this.m_20189_())) {
                this.plow(player);
            }
        }
    }

    private void plow(Player player) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof TieredItem)) continue;
            float offset = 38.0f - (float)i * 38.0f;
            double blockPosX = this.m_20185_() + (double)Mth.m_14031_((float)((float)Math.toRadians(this.m_146908_() - offset))) * 1.7;
            double blockPosZ = this.m_20189_() - (double)Mth.m_14089_((float)((float)Math.toRadians(this.m_146908_() - offset))) * 1.7;
            BlockPos blockPos = new BlockPos(blockPosX, this.m_20186_() - 0.5, blockPosZ);
            boolean damageable = stack.m_41763_();
            int count = stack.m_41613_();
            stack.m_41720_().m_6225_((UseOnContext)new ProxyItemUseContext(player, stack, new BlockHitResult(Vec3.f_82478_, Direction.UP, blockPos, false)));
            if (!damageable || stack.m_41613_() >= count) continue;
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
            this.updateSlot(i);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            this.openContainer(player);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(PLOWING, (Object)((Boolean)this.f_19804_.m_135370_(PLOWING) == false ? 1 : 0));
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public void updateSlot(int slot) {
        if (!this.f_19853_.f_46443_) {
            if (this.inventory.getStackInSlot(slot).m_41619_()) {
                this.f_19804_.m_135381_((EntityDataAccessor)TOOLS.get(slot), (Object)ItemStack.f_41583_);
            } else {
                this.f_19804_.m_135381_((EntityDataAccessor)TOOLS.get(slot), (Object)this.inventory.getStackInSlot(slot));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.f_19804_.m_135370_((EntityDataAccessor)TOOLS.get(i));
    }

    @Override
    public Item getCartItem() {
        return (Item)AstikorCarts.Items.PLOW.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLOWING, (Object)false);
        for (EntityDataAccessor param : TOOLS) {
            this.f_19804_.m_135372_(param, (Object)ItemStack.f_41583_);
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(PLOWING, (Object)compound.m_128471_("Plowing"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Plowing", ((Boolean)this.f_19804_.m_135370_(PLOWING)).booleanValue());
    }

    private void openContainer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> new PlowContainer(windowId, playerInventory, (AbstractDrawnInventoryEntity)this), this.m_5446_()), buf -> buf.writeInt(this.m_19879_()));
        }
    }
}

